REM @ECHO OFF
REM cleanup of old temp files
del new_data.txt
del NGDC_kp.txt
REM get names for new files
set /p MYFI="File to get (e.g., for 1st quater 2024 data use '2024Q1_DGD.txt'): "
set /p MYFO="File name for result of conversion to old format: "
ECHO This script gets Kp data from ftp://ftp.noaa.swpc.gov/pub/indices/old_indices/ and converts it to 2014 NGDC format ofthe same data
ECHO %MYFI%
ECHO %MYFO%
REM This script: 
REM 	1. ftp-pulls user-entered data file from SWPC ftp site using %1
REM  2. preprocesses the download ftp file for possible bad data
REM  3. call powershell to reformat the kp to the older style 
REM  4. calls the conversion script to convert the data to the older file layout
REM  5. call powershell to clean up extra spacing issues and perfect the layout
REM  6. rename the revised format data file to the user-entered filename (%2)
REM Intended use is "Converter Input_FTP_source_file_from_SWPCFile.txt Output_old_NGDCfile.txt
REM the ftp://path/ bit is already coded so only the filename is needed
REM command line arguments are %1 through %9 by default
REM %1 is ftp file, %2 is final output file with kp data in old format 
REM powershell.exe -Command "Invoke-WebRequest -Outfile new_data.txt ftp://ftp.swpc.noaa.gov/pub/indices/old_indices/2020Q1_DGD.txt"
powershell.exe -Command "Invoke-WebRequest -Outfile new_data.txt ftp://ftp.swpc.noaa.gov/pub/indices/old_indices/%MYFI%"
unix2dos new_data.txt
powershell -Command "(gc new_data.txt) -replace '-1.00', ' XX'  | Out-File -encoding ASCII new_data.txt"
REM above line replaces the "-" bad data indicators that are usually in the last line of data (current data)
REM converts from new format Kp reporting to the older style (e.g., 0.33 to 0+)
powershell -Command "(gc new_data.txt) -replace ' 0.00', ' 0 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 0.33', ' 0p' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 0.67', ' 1-' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 1.00', ' 1 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 1.33', ' 1p' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 1.67', ' 2-' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 2.00', ' 2 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 2.33', ' 2p' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 2.67', ' 3-' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 3.00', ' 3 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 3.33', ' 3p' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 3.67', ' 4-' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 4.00', ' 4 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 4.33', ' 4p' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 4.67', ' 5-' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 5.00', ' 5 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 5.33', ' 5p' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 5.67', ' 6-' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 6.00', ' 6 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 6.33', ' 6p' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 6.67', ' 7-' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 7.00', ' 7 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 7.33', ' 7p' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 7.67', ' 8-' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 8.00', ' 8 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 8.33', ' 8p' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 8.67', ' 9-' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 9.00', ' 9 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 9.33', ' 9p' | Out-File -encoding ASCII new_data.txt"
REM Kp_SWPC2NGDC_Converter.bat changes from new SWPC file layout to approximate the older NGDC format
REM It must be called as a dos command from powershell or it will stop the script before the cleanup 
powershell -Command " cmd /c 'Kp_SWPC2NGDC_Converter > NGDC_kp.txt'"
REM these next lines clean up extra spaces in the file NGDC_kp.txt and convert "p" to "+"
powershell -Command "(gc NGDC_kp.txt) -replace '- X', '-X' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 0', '-0' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 1', '-1' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 2', '-2' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 3', '-3' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 4', '-4' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 5', '-5' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 6', '-6' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 7', '-7' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 8', '-8' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 9', '-9' | Out-File -encoding ASCII NGDC_kp.txt"
REM "+" case does not mirror "-" case because of different use rules in powershell 
powershell -Command "(gc NGDC_kp.txt) -replace 'p ', '+' | Out-File -encoding ASCII NGDC_kp.txt"
copy /y NGDC_kp.txt %MYFO%
