REM @ECHO OFF
REM cleanup of old temp files
del new_data.txt
del NGDC_kp.txt
REM
REM Source as of December 2024 is now https://kp.gfz-potsdam.de, the current host of the Kp index data WDC.
REM Tab formatted file to get is at https://kp.gfz-potsdam.de/app/files/pqlyymm.tab, which is the last month of definitive data.
REM It takes a few days for this to become available after the next month begins (e.g., Nov. 2024 became available on Dec 5, 2024).
REM set /p MYFI="File to get (e.g., for 1st quarter 2024 data use '2024Q1_DGD.txt'): "
REM
REM get a name for the new KP data file
set /p MYFO="File name for result of conversion to old format: "
REM ECHO This script gets Kp data from ftp://ftp.noaa.swpc.gov/pub/indices/old_indices/ and converts it to 2014 NGDC format ofthe same data
ECHO This script get Kp data from https://kp.gfz-potsdam.de/kpdata 
ECHO and converts it to 2014 NGDC format ofthe same data
REM  (FTP at NOAA became inaccessible as of the 09/2024; many browsers no longer support ftp and a seprate ftp client would be needed)
REM  (MS powershell does not have its own ftp client, uses MS Edge)
REM ECHO %MYFI%
ECHO %MYFO%
REM This script used to: 
REM  1. Download tab formatted data from the WDC using %1 (pqlyymm.tab above)
REM  2. preprocess the download file for possible bad data (still needed?)
REM  3. call powershell to reformat the Kp to the 2014 NGDC style 
REM  4. call the conversion script to convert the data to the older file layout
REM  5. call powershell to clean up extra spacing issues and perfect the layout
REM  6. rename the revised format data file to the user-entered filename (%2)
REM Intended use is "Converter Input_FTP_source_file_from_SWPCFile.txt Output_old_NGDCfile.txt
REM command line arguments are %1 through %9 by default
REM %1 is ftp file, %2 is final output file with kp data in old format 
REM powershell.exe -Command "Invoke-WebRequest -Outfile new_data.txt https://kp.gfz-potsdam.de/app/files/pqlyymm.tab"
powershell.exe -Command "Invoke-WebRequest -Outfile new_data.txt https://kp.gfz-potsdam.de/app/files/pqlyymm.tab"
unix2dos new_data.txt
powershell -Command "(gc new_data.txt) -replace '  ', ' '  | Out-File -encoding ASCII new_data.txt"
REM above line removes double spaces
REM commands to replace odd characters from data section to match Kp reporting to the older style (e.g.," 0o" to "0 ")
powershell -Command "(gc new_data.txt) -replace ' 0o', ' 0 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 1o', ' 1 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 2o', ' 2 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 3o', ' 3 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 4o', ' 4 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 5o', ' 5 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 6o', ' 6 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 7o', ' 7 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 8o', ' 8 ' | Out-File -encoding ASCII new_data.txt"
powershell -Command "(gc new_data.txt) -replace ' 9o', ' 9 ' | Out-File -encoding ASCII new_data.txt"
REM Kp_SWPC2NGDC_Converter.bat changes from new SWPC file layout to approximate the older NGDC format
REM It must be called as a dos command from powershell or it will stop the script before the cleanup 
powershell -Command " cmd /c 'Kp_TAB_to_NGDC_Converter > NGDC_kp.txt'"
REM these next lines clean up extra spaces in the file NGDC_kp.txt and convert "+ " to "+"
REM powershell -Command "(gc NGDC_kp.txt) -replace '- X', '-X' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 0', '-0' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 1', '-1' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 2', '-2' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 3', '-3' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 4', '-4' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 5', '-5' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 6', '-6' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 7', '-7' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 8', '-8' | Out-File -encoding ASCII NGDC_kp.txt"
powershell -Command "(gc NGDC_kp.txt) -replace '- 9', '-9' | Out-File -encoding ASCII NGDC_kp.txt"
REM "+" case does not mirror "-" case because + is a special character in powershell, 
REM Must use slash '\' to indicate treatment as a string 
REM ${c:NGDC_kp.txt} = ${c:NGDC_kp.txt} -replace '\+ ','+'
powershell -Command "(gc NGDC_kp.txt) -replace '\+ ', '+' | Out-File -encoding ASCII NGDC_kp.txt"
copy /y NGDC_kp.txt %MYFO%
